/*
//###########################################################################
//
// FILE:	Example_Flash2810_API.cmd
//
// TITLE:	Linker Command File For F2810 Flash API Example
//
//###########################################################################
// $TI Release: Flash281x API V2.10 $
// $Release Date: August 4, 2005 $
//###########################################################################
*/

/* Define the memory block start/length for the F2812  
   PAGE 0 will be used to organize program sections
   PAGE 1 will be used to organize data sections

   Notes: 
         Memory blocks on F281x are uniform (ie same
         physical memory) in both PAGE 0 and PAGE 1.  
         That is the same memory region should not be
         defined for both PAGE 0 and PAGE 1.
         Doing so will result in corruption of program 
         and/or data. 
*/

MEMORY
{
PAGE 0:    /* Program Memory */
           /* Memory (RAM/FLASH/OTP) blocks can be moved to PAGE1 for data allocation */

   RAMM0M1     : origin = 0x000100, length = 0x000200     /* on-chip RAM block M0 */
   OTP         : origin = 0x3D7800, length = 0x000800     /* on-chip OTP */
   FLASHJ      : origin = 0x3D8000, length = 0x002000     /* on-chip FLASH */
   FLASHI      : origin = 0x3DA000, length = 0x002000     /* on-chip FLASH */
   FLASHH      : origin = 0x3DC000, length = 0x004000     /* on-chip FLASH */
   FLASHG      : origin = 0x3E0000, length = 0x004000     /* on-chip FLASH */
   FLASHF      : origin = 0x3E4000, length = 0x004000   /* on-chip FLASH */
   FLASHE      : origin = 0x3E8000, length = 0x004000     /* on-chip FLASH */
   FLASHD      : origin = 0x3EC000, length = 0x004000     /* on-chip FLASH */
   FLASHC      : origin = 0x3F0000, length = 0x004000     /* on-chip FLASH */
   FLASHB      : origin = 0x3F4000, length = 0x002000     /* on-chip FLASH */
   FLASHA      : origin = 0x3F6000, length = 0x001F80     /* on-chip FLASH */
   CSM_RSVD    : origin = 0x3F7F80, length = 0x000076     /* Part of FLASHA.  Program with all 0x0000 when CSM is in use. */
   BEGIN       : origin = 0x3F7FF6, length = 0x000002     /* Part of FLASHA.  Used for "boot to Flash" bootloader mode. */
   CSM_PWL     : origin = 0x3F7FF8, length = 0x000008     /* Part of FLASHA.  CSM password locations in FLASHA */
   ROM         : origin = 0x3FF000, length = 0x000FC0     /* Boot ROM available if MP/MCn=0 */
   RESET       : origin = 0x3FFFC0, length = 0x000002     /* part of boot ROM (MP/MCn=0) or XINTF zone 7 (MP/MCn=1) */
   VECTORS     : origin = 0x3FFFC2, length = 0x00003E     /* part of boot ROM (MP/MCn=0) or XINTF zone 7 (MP/MCn=1) */

PAGE 1 :   
   SCIA        : origin = 0x007050, length = 0x000010     /* SCI-A registers */
   RAML0L1     : origin = 0x008000, length = 0x002000     /* on-chip RAM block L0 & L1 */
   RAMM0M1     : origin = 0x000300, length = 0x000500     /* on-chip RAM block M0 */
   RAMH0_1	   : origin = 0x3F8000, length = 0x001000     /* on-chip RAM block H0 */
   RAMH0_2	   : origin = 0x3F9000, length = 0x001000     /* on-chip RAM block H0 */

PAGE 2 :
   RAMH0_1	   : origin = 0x3F8000, length = 0x001000     /* on-chip RAM block H0 */
   RAMH0_2	   : origin = 0x3F9000, length = 0x001000     /* on-chip RAM block H0 */
}

 
SECTIONS
{
	.text_unsecured		: > RAMM0M1		PAGE = 0
	{
		.\debug\obj\unlock_main.obj (.text)
		.\debug\obj\DSP281x_CodeStartBranch.obj (.text)
		.\debug\obj\Example_Flash281x_CsmKeys.obj (.text)
		.\debug\obj\DSP281x_MemCopy.obj (.text)
		rts2800_ml.lib (.text)
	}
  	.econst_unsecured	: > RAMM0M1		PAGE = 0
	{
		.\debug\obj\unlock_main.obj (.econst)
	}


	.text            	:	LOAD = RAMH0_1, 
                         	RUN = RAML0L1, 
                         	LOAD_START(_textLoadStart),
                         	LOAD_END(_textLoadEnd),
                         	RUN_START(_textRunStart),
                         	PAGE = 1

	.econst            	:	LOAD = RAMH0_1, 
                         	RUN = RAML0L1, 
                         	LOAD_START(_econstLoadStart),
                         	LOAD_END(_econstLoadEnd),
                         	RUN_START(_econstRunStart),
                         	PAGE = 1

	.cinit           : > RAMM0M1		PAGE = 0


    
	/* User Defined Sections   */
	codestart           : > RAMM0M1		PAGE = 0
	BlockTransferBuffer1: > RAMH0_1		PAGE = 2
	BlockTransferBuffer2: > RAMH0_2		PAGE = 2
	csmpasswds          : > CSM_PWL     PAGE = 0
	csm_rsvd            : > CSM_RSVD    PAGE = 0


	/* Allocate uninitalized data sections: */
	.stack              : > RAMM0M1		PAGE = 1
	.ebss               : > RAML0L1		PAGE = 1

   /* .reset is a standard section used by the compiler.  It contains the */ 
   /* the address of the start of _c_int00 for C Code.   /*
   /* When using the boot ROM this section and the CPU vector */
   /* table is not needed.  Thus the default type is set here to  */
   /* DSECT  */ 
   .reset				: > RESET,      PAGE = 0, TYPE = DSECT
   vectors				: > VECTORS     PAGE = 0, TYPE = DSECT
   .SCIARegs			: > SCIA		PAGE = 1

}